@extends('backend.master')

@section('title')
    {{ @$data['title'] }}
@endsection
@section('content')
    <div class="page-content">
        {{-- bradecrumb Area S t a r t --}}
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1">{{ $data['title'] }}</h4>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ ___('common.home') }}</a></li>
                        <li class="breadcrumb-item" aria-current="page"><a
                                href="{{ route('users.index') }}">{{ ___('common.properties') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ ___('common.add_new') }}</li>
                    </ol>
                </div>
            </div>
        </div>
        {{-- bradecrumb Area E n d --}}
        <div class="card ot-card">
            <div class="card-body">
                <form action="{{ route('properties.store') }}" enctype="multipart/form-data" method="post" id="visitForm">
                    @csrf
                    <div class="row mb-3">

                        <div class="col-md-6 mb-3">
                            <label for="_name" class="form-label ">{{ ___('common.Name') }}</label>
                            <input class="form-control ot-input @error('name') is-invalid @enderror" name="name"
                                list="datalistOptions" id="_name" placeholder="{{ ___('common.name') }}"
                                value="{{ old('name') }}">
                            @error('name')
                                <div id="validation1" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="size_of_property" class="form-label ">{{ ___('common.Size of Property') }}
                                [{{ ___('common.Square Feet') }}]</label>
                            <input class="form-control ot-input @error('size_of_property') is-invalid @enderror"
                                name="size_of_property" type="number" list="datalistOptions" id="size_of_property"
                                placeholder="{{ ___('common.234') }}" value="{{ old('size_of_property') }}">
                            @error('size_of_property')
                                <div id="validation2" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="Bedroom" class="form-label ">{{ ___('common.Bedroom') }}
                            </label>
                            <input class="form-control ot-input @error('bedroom') is-invalid @enderror" name="bedroom"
                                type="number" list="datalistOptions" id="Bedroom" placeholder="{{ ___('common.3') }}"
                                value="{{ old('bedroom') }}">
                            @error('bedroom')
                                <div id="validation3" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="bathroom" class="form-label ">{{ ___('common.Bathroom') }}</label>
                            <input class="form-control ot-input @error('bathroom') is-invalid @enderror" name="bathroom"
                                type="number" list="datalistOptions" id="bathroom" placeholder="{{ ___('common.3') }}"
                                value="{{ old('bathroom') }}">
                            @error('bathroom')
                                <div id="validation4" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>


                        <div class="col-md-6 mb-3">
                            <label for="rent_price" class="form-label ">{{ ___('common.Rent Price') }}</label>
                            <input class="form-control ot-input @error('rent_price') is-invalid @enderror" name="rent_price"
                                type="number" list="datalistOptions" id="rent_price"
                                placeholder="{{ ___('common.40,000') }}" value="{{ old('rent_price') }}">
                            @error('rent_price')
                                <div id="validation5" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="Flat_Number" class="form-label ">{{ ___('common.Flat Number') }}</label>
                            <input class="form-control ot-input @error('Flat_Number') is-invalid @enderror"
                                name="Flat_Number" list="datalistOptions" id="Flat_Number"
                                placeholder="{{ ___('common.3') }}" value="{{ old('Flat_Number') }}">
                            @error('Flat_Number')
                                <div id="validation6" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="validationServer04" class="form-label">{{ ___('common.Property Type') }}</label>
                            <select
                                class="nice-select niceSelect bordered_style wide @error('property_type') is-invalid @enderror"
                                name="property_type" id="validationServer04" aria-describedby="validationServer04Feedback"
                                value="{{ old('property_type') }}">
                                <option value="0" selected>{{ ___('common.Residential') }}</option>
                                <option value="1">{{ ___('common.Commercial') }}</option>
                            </select>
                            @error('property_type')
                                <div id="validation7" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="property_category"
                                class="form-label">{{ ___('common.Property Category') }}</label>
                            <select
                                class="nice-select niceSelect bordered_style wide @error('property_category') is-invalid @enderror"
                                name="property_category" id="property_category" aria-describedby="validation8"
                                value="{{ old('property_category') }}">
                                @foreach ($data['property_categories'] as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('property_category')
                                <div id="validation8" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3 mt-3">
                            <input class="form-check-input mr-4  common-key" type="checkbox"
                                name="drawing_dining_combined" id="drawing_dinning_combined" />
                            <label class="form-check-label"
                                for="drawing_dinning_combined">{{ ___('common.drawing dining combined') }}<span
                                    class="fillable"> *</span></label>
                        </div>

                        <div class="col-md-6 mb-3 mt-3">
                            <input class="form-check-input mr-4  common-key" type="checkbox" name="vacant"
                                id="vacant" />
                            <label class="form-check-label" for="vacant">{{ ___('common.vacant') }}<span
                                    class="fillable"> *</span></label>
                        </div>

                        <div class="col-md-6 mb-3 mt-3">
                            {{-- File Upload --}}
                            <label class="form-label" for="inputImage">{{ ___('common.image') }}<span class="fillable">
                                    *</span></label>
                            <div class="ot_fileUploader left-side mb-3">
                                <input class="form-control" type="text" placeholder="{{ ___('common.image') }}"
                                    readonly="" id="placeholder">
                                <button class="primary-btn-small-input" type="button">
                                    <label class="btn btn-lg ot-btn-primary"
                                        for="fileBrouse">{{ ___('common.browse') }}</label>
                                    <input type="file" class="d-none form-control" name="image" id="fileBrouse"
                                        accept="image/*">
                                </button>
                            </div>
                            @error('image')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>


                        <div class="col-md-6 mb-3 mt-3">
                            <label for="address" class="form-label ">{{ ___('common.Address') }}</label>
                            <input class="form-control ot-input @error('address') is-invalid @enderror" name="address"
                                list="datalistOptions" id="address" placeholder="{{ ___('common.Property Address') }}"
                                value="{{ old('address') }}">
                            @error('address')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-6 mb-3 mt-3">
                            <label for="post_code" class="form-label ">{{ ___('common.Post Code') }}</label>
                            <input class="form-control ot-input @error('post_code') is-invalid @enderror" name="post_code"
                                list="datalistOptions" id="post_code"
                                placeholder="{{ ___('common.Property post_code') }}" value="{{ old('post_code') }}">
                            @error('post_code')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="Completion" class="form-label">{{ ___('common.Completion') }}</label>
                            <select
                                class="nice-select niceSelect bordered_style wide @error('completion') is-invalid @enderror"
                                name="completion" id="Completion" aria-describedby="validation102"
                                value="{{ old('completion') }}">
                                <option value="1">{{ ___('common.Completed') }}</option>
                                <option value="0">{{ ___('common.Under Construction') }}
                                </option>
                            </select>
                            @error('completion')
                                <div id="validation102" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="country" class="form-label">{{ ___('common.Country') }}</label>
                                <select class="nice-select niceSelect bordered_style wide" name="country" id="country">
                                    @foreach ($data['countries'] as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="state" class="form-label">{{ ___('common.State') }}</label>
                                <select class="nice-select niceSelect bordered_style wide state-dropdown" name="state"
                                    id="state_2">
                                </select>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="city" class="form-label">{{ ___('common.City') }}</label>
                                <select class="nice-select niceSelect bordered_style wide city-dropdown" name="city"
                                    id="city_1">
                                </select>
                            </div>
                        </div>



                        <div class="col-md-6 mb-3">
                            <label for="Status" class="form-label">{{ ___('common.Status') }}</label>
                            <select
                                class="nice-select niceSelect bordered_style wide @error('status') is-invalid @enderror"
                                name="status" id="Status" aria-describedby="validation103"
                                value="{{ old('name') }}">
                                <option value="1">{{ ___('common.Active') }}</option>
                                <option value="0">{{ ___('common.Inactive') }}
                                </option>
                            </select>
                            @error('status')
                                <div id="validation103" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-12 mb-3">
                            <label for="Description" class="form-label ">{{ ___('common.Description') }}
                                <span class="fillable"> *</span></label>
                            <textarea name="Description" id="Description" placeholder="{{ ___('common.Description') }}"
                                class="form-control m-0 @error('Description') is-invalid @enderror">{{ old('Description') }}</textarea>
                            @error('Description')
                                <div id="xfg" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-24">
                            <div class="text-end">
                                <button type="submit" class="btn btn-lg ot-btn-primary"><span><i
                                            class="fa-solid fa-save"></i>
                                    </span>{{ ___('common.Create') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            $("#country").change(function() {
                var countryId = $(this).val();
                var baseUrl = $('meta[name="base-url"]').attr("content");

                $.ajax({
                    url: baseUrl + "/properties/get-states/" + countryId,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                         $('#state_2').empty();

                        $.each(data.states, function(key, value) {
                            $('#state_2').append('<option value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                        $('#state_2').niceSelect('destroy');
                        $('#state_2').niceSelect();


                    },
                    error: function(xhr, textStatus, errorThrown) {
                        console.error(xhr.responseText);
                    }
                });
            });

            $('#state_2').on('change', function() {
                var stateId = $(this).val();

                // Find all city dropdowns and update them
                $(".city-dropdown").each(function(index) {
                    var cityDropdown = $(this);
                    var cityId = "city_" + (index + 1); // Generate dynamic ID
                    cityDropdown.attr("id", cityId);


                    $.ajax({
                        url: "/properties/get-cities/" + stateId,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            cityDropdown.empty();
                            $.each(data.cities, function(key, value) {
                                cityDropdown.append('<option value="' + value
                                    .id + '">' + value.name + '</option>');
                            });

                            // Destroy any previous instance of niceSelect and reinitialize for the current dropdown
                            cityDropdown.niceSelect('destroy');
                            cityDropdown.niceSelect();
                        },
                        error: function(xhr, textStatus, errorThrown) {
                            console.error(xhr.responseText);
                        }
                    });
                });
            });

        });
    </script>
@endpush
